/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

#include "quotesrecord.h"

union stringConverter
{
	char char_vers[ 2 ];
	short short_vers;
};

quotesrecord::quotesrecord( void )
{
	source_string = "";
	stripped_string = "";
}

quotesrecord::quotesrecord( const string &s )
{
	source_string = s;
	strip(source_string);
}

quotesrecord::quotesrecord( const quotesrecord & q )
{
	source_string = q.source_string;
	stripped_string = q.stripped_string;
	elems = q.elems;
}

quotesrecord::~quotesrecord( void )
{
	/* Do nothing. Absolutely nothing. */;
}

const quotesrecord & quotesrecord::set_source( const string & s )
{
	source_string = s;
	strip( source_string );
	return *this;
}

const string & quotesrecord::strip( const string & s )
{
	string buffer = "";
	int c;
	int l = ( int ) s.length();
	short string_count = 0;
	bool in_quote = false;
	stringConverter r;
	
	elems.clear();
	
	stripped_string.clear();
	
	for( c = 0; c < l; c++ )
	{
		if( s[ c ] == 34 )
		{
			if( ! in_quote )
			{
				in_quote = true;
				buffer = "";
				r.short_vers = string_count++;
				stripped_string += ( char ) 1;
				stripped_string += r.char_vers[ 0 ];
				stripped_string += r.char_vers[ 1 ];
			}
			else
			{
				in_quote = false;
				elems.push_back( c2escape( buffer ) );
			}
		}
		else
		{
			if( in_quote )
			{
				buffer += s[c];
			}
			else
			{
				stripped_string += s[ c ];
			}
		}
	}
	return stripped_string;
}

string quotesrecord::restore( const string & s )
{
	string output_buffer;
	int c;
	int l = ( int ) s.length();
	stringConverter r;
	
	for( c = 0; c < l; c++ )
	{
		if( s[ c ] == 1 )
		{
			r.char_vers[ 0 ] = s[ c + 1 ];
			r.char_vers[ 1 ] = s[ c + 2 ];
			output_buffer += elems[ r.short_vers ];
			c += 2;
		}
		else
		{
			output_buffer += s[ c ];
		}
	}
	return output_buffer;
}

string quotesrecord::c2escape( const string & s )
{
	string s2;
	if( s == "" )
	{
		return "\\n";
	}
	s2 = replaceall( s2, "\\", "\\\\" );
	s2 = replaceall( s, ",", "\\c" );
	s2 = replaceall( s2, ">", "\\g" );
	return s2;
}

string quotesrecord::c2unescape( const string & s )
{
	string s2;
	if( s == "\\n" )
	{
		return "";
	}
	s2 = replaceall( s2, "\\\\", "\\" );
	s2 = replaceall( s, "\\c", "," );
	s2 = replaceall( s2, "\\g", ">" );
	s2 = replaceall( s2, "\\l", "<" );
	return s2;
}